#include <iostream>
#include <vector>
#include <unordered_map>
#include <map>
#include <algorithm>
using namespace std;

int main() {
    int n;
    cin >> n;
    vector<long long> a(n);
    for (int i = 0; i < n; i++) {
        cin >> a[i];
    }

    long long prefixSum = 0;
    unordered_map<long long, vector<int>> prefixMap;
    prefixMap[0].push_back(-1);

    for (int i = 0; i < n; i++) {
        prefixSum += a[i];
        prefixMap[prefixSum].push_back(i);
    }

    int maxFrequency = 0;

    for (const auto& entry : prefixMap) {
        const auto& indices = entry.second;
        if (indices.size() > 1) {
            map<long long, int> freqCounter;
            for (int i = indices[0] + 1; i <= indices.back(); i++) {
                freqCounter[a[i]]++;
            }
            for (const auto& freq : freqCounter) {
                maxFrequency = max(maxFrequency, freq.second);
            }
        } else {
            maxFrequency = max(maxFrequency, 1);
        }
    }

    cout << maxFrequency << endl;

    return 0;
}